{ Module
 Slink.pas
 User Interface for 'Orgmdll Demo
 to Sharp Organizers
 (C) 1995 1996 Alistair Traylen Creative Binary Engineering P/L
}

unit Slink;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
	Forms, Dialogs, StdCtrls, Ircomms, ExtCtrls, Grids, Outline,
  FileCtrl, Buttons, TabNotBk, Menus,Tabs;
var
  LastTab: Integer;

type
   TSlinkMain = class(TForm)
    OpenDialog1: TOpenDialog;
    MainMenu1: TMainMenu;
    mnuFile: TMenuItem;
    Exit2: TMenuItem;
    ScrapMenu: TPopupMenu;
    mnuHelp: TMenuItem;
    OrganizerFileManager1: TMenuItem;
    Diags1: TMenuItem;
    Apps: TTabbedNotebook;
    Label1: TLabel;
    Label2: TLabel;
    PCFiles: TFileListBox;
    BtnSend: TBitBtn;
    BtnGet: TBitBtn;
    DirList: TListBox;
    OrganizerDrive: TComboBox;
    PCFileLocation: TDirectoryListBox;
    Connect: TBitBtn;
    DriveComboBox1: TDriveComboBox;
    chkOverwrite: TRadioButton;
    Append: TRadioButton;
    Bu: TBitBtn;
    re: TBitBtn;
    connected: TButton;
    LastErr: TButton;
    QueryDisplay: TButton;
    QueryFile: TButton;
    SendFile: TButton;
    GetFile: TButton;
    Memo1: TMemo;
    Button1: TButton;

    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure GetFileClick(Sender: TObject);
    procedure connectedClick(Sender: TObject);
    procedure QueryDisplayClick(Sender: TObject);
    procedure SendFileClick(Sender: TObject);
    procedure BtnGetClick(Sender: TObject);
    procedure ConnectClick(Sender: TObject);
    procedure BtnSendClick(Sender: TObject);
    procedure LastErrClick(Sender: TObject);
    procedure QueryFileClick(Sender: TObject);
    procedure Exit2Click(Sender: TObject);
    procedure OrganizerDriveChange(Sender: TObject);
    procedure OrganizerFileManager1Click(Sender: TObject);
    procedure Diags1Click(Sender: TObject);
    procedure BuClick(Sender: TObject);
    procedure reClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);



  private
		{ Private declarations }
    SendBuffer: array[0..550] of char;
  public
    { Public declarations }
       ElapsedCount: longint;
  end;



 var
	SlinkMain: TSlinkMain;

implementation

{$R *.DFM}

procedure TSlinkMain.FormCreate(Sender: TObject);
{ creates neccesary objects at form create time
  calls functions to read the settings from the ini file
  and sets forms and controls to values from ini file
 }

begin
     OrganizerDrive.Items.Add('S1: Main Memory');
     OrganizerDrive.Items.Add('S2: Card Memory');
     OrganizerDrive.ItemIndex:=0;
     IROpen;
 end;

procedure TSlinkMain.FormDestroy(Sender: TObject);
begin
IRClose;
end;


procedure TSlinkMain.GetFileClick(Sender: TObject);
var
res: integer;
r: longint;
c: string;
b:array [0..512] of char;
d:array [0..512] of char;

begin
c:= InputBox('File Name To Receive', 'FileName ', 'S1:TEL1');
if length(c)=0 then exit;
StrPCopy(b,c);
c:= InputBox('File Name', 'PC FileName ', 'TEL1.BOX');
if length(c)=0 then exit;
StrPcopy(d,c);
res:=IRFileTransfer(IRRECEIVE,CSV_OVERWRITE,d,b);
Memo1.Lines.Add ('result from receive  := '+IntToStr(res));
end;

procedure TSlinkMain.connectedClick(Sender: TObject);
var
res: word;
begin
res:=IrOnline(36000);   { six minutes }
if res= 1 then             { if true }
     MessageDlg('On-Line', mtInformation,
      [mbOk], 0)

else
 MessageDlg('Off-Line', mtInformation,
      [mbOk], 0);

      end;

procedure TSlinkMain.QueryDisplayClick(Sender: TObject);
var
res: integer;
r: longint;
cmd: array [0..60]of char;
c: string;
buf: array [0..4048] of char;
begin

c:= InputBox('Organizer Command Query', '','');
StrPCopy(cmd,c);
IRQueryToBuff(cmd,buf);
  MessageDlg(StrPas(buf), mtInformation,
      [mbOk], 0)


end;

procedure TSlinkMain.SendFileClick(Sender: TObject);
var
 res: integer;
 Fname: array [0..256] of char;

 begin
  OpenDialog1.Filter := 'Wizard Files (*.Wiz)|*.Wiz|Organizer File (*.Box)|*.Box';
 if OpenDialog1.Execute then
  begin
    StrPCopy(Fname,OpenDialog1.FileName);
    res:=IRFileTransfer(IRSEND,CSV_OVERWRITE,Fname,Fname);

  end;
  if res=IRFILEFAIL then
  MessageDlg('File Error , Couldn''t open file', mtInformation,
      [mbOk], 0)
  else if res=IRFAIL then
       MessageDlg('Protocol Error, Couldn''t Send Data', mtInformation,
      [mbOk], 0)
  else
      MessageDlg('Sent File OK', mtInformation,
      [mbOk], 0);

 end;
procedure TSlinkMain.BtnGetClick(Sender: TObject);

{ Get all tagged files from the Organizer }
var
res: integer;
r: longint;
temp: array [0..512] of char;
Ofile:array [0..512] of char;
Pfile:array [0..512] of char;
PCFilePath: array [0..512] of char;
FileFormat: Integer;
loop: integer;
 max: integer;
 s: string;
 Spoint: pchar;
 OverwriteAllfiles: boolean;
 begin
 OverwriteAllfiles:=false;
 StrPCopy(PCFilePath,PCFiles.Directory);
 StrCat(PCFilePath,'\');
  FileFormat:=CSV_OVERWRITE;
  Max:=DirList.Items.Count;
   for loop:= 0 to Max-1 do
     begin
       if DirList.Selected[loop] then
        begin
          StrPcopy(temp,DirList.Items.Strings[loop]);
          if OrganizerDrive.ItemIndex=0 then
            Strcopy(Ofile,'S1:')    { drive name }
          else
            Strcopy(Ofile,'S2:');    { drive name }
          Strcat(Ofile,temp);        { append filename for organiser}
          Strcopy(Pfile,PCFilePath); {set PC file path }
          Strcat(temp,'.WIZ');       { add extension for pc filename }
          Strcat(Pfile,temp);
          { here we see if the file exists if it does prompt user to overwrite it or all files }
          res:=-1; { default the result }
          if (FileExists(StrPas(Pfile))) then
           begin
               res:=MessageDlg(StrPas(Pfile)+' already exists, Do you wish to overwrite it ?',
               mtWarning, [mbYes, mbNo], 0);
            end;
           if (res =-1) or (res=mrYes) then res:=IRFileTransfer(IRRECEIVE,FileFormat,Pfile,Ofile);
          end;
      end;
    PCFiles.Update;
   end;

procedure TSlinkMain.ConnectClick(Sender: TObject);
{ go online and get file list }
var
Ex: pchar;          { file extension pointer }
res: bytebool;      { result }
pass: integer;
DirF: TextFile;      { the file of the directory entries retrieved from organizer }
entry: string;
FilerFlag: bytebool;
FileName: array[0..20] of char;
begin
  DirList.Clear;
  FilerFlag:=false;
   pass:=IRConnect;

    if pass=IRSUCCESS then   { password is not set or organizer is unlocked }
     begin
      if OrganizerDrive.ItemIndex=0 then
            IRDir('S1:','Organise.dir')
      else
            IRDir('S2:','Organise.dir');
       { Add organizer files to list but filter unwanted entries from the file list }
         try
          AssignFile(DirF,'Organise.dir');
          Reset(DirF);
          while not Eof(DirF) do
             begin
                 Readln(DirF, entry);
                 StrPCopy(FileName,entry);     { convert to null terminated }
                 Ex:= StrPos(Filename,'.IDX');  { we only want the idx file names }
                   if Ex <> nil  then
                    begin
                     Ex[0]:= #0;     {strip of the file extension 'IDX' by killing string at pointer}
                     DirList.Items.Add(StrPas(Filename));
                    end;
             end;
        except
         CloseFile(DirF);
        end;
    CloseFile(DirF);
 end
 else
  MessageDlg('Could not Connect to the Organizer', mtInformation,
      [mbOk], 0);
end;
procedure TSlinkMain.BtnSendClick(Sender: TObject);
var
res: integer;
r: longint;
d: integer;
temp: array [0..512] of char;
Pfile:array [0..512] of char;
Ofile: array [0..20] of char;
PCFilePath: array [0..512] of char;
ODrive: array [0..5] of char;
FileFormat: Integer;
loop: integer;
 max: integer;
 s: string;
 Spoint :pchar;
 begin
   if chkOverWrite.Checked=true then FileFormat:=CSV_OVERWRITE else fileformat:=CSV_APPEND;
  Max:=PCFiles.Items.Count;
   for loop:= 0 to Max-1 do
     begin
       if PCFiles.Selected[loop] then
        begin
          StrPcopy(Pfile,PCFiles.Items.Strings[loop]);
          { GET ORGANIZER DEST DRIVE LETTER FROM THE COMBO BOX }
          if OrganizerDrive.ItemIndex=0 then
            Strcopy(ODrive,'S1:')    { drive name }
          else
            Strcopy(ODrive,'S2:');    { drive name }
          Strcopy(Ofile,ODrive);
          Strcat(Ofile,Pfile);  { Same name}
          StrLower(Ofile);
          Spoint:=StrPos(Ofile,'.');
          Strcopy(Spoint,#0);
          StrUpper(Ofile);
          res:=IRFileTransfer(IRSEND,FileFormat,Pfile,OFile)
       end;
     end;
end;

procedure TSlinkMain.LastErrClick(Sender: TObject);
var
buf: array [0..512] of char;
begin
  IRError(buf);
  MessageDlg(StrPas(buf), mtInformation,
      [mbOk], 0)

end;

procedure TSlinkMain.QueryFileClick(Sender: TObject);
var
res: integer;
cmd: array [0..60]of char;
c: string;
filename: array [0..2000] of char;
begin
c:= InputBox('Organizer Command Query', '', '');
if length(c) =0 then exit;      {test for cancel or no entry}
StrPCopy(cmd,c);
c:= InputBox('File Name for the Result', '', 'C:\');
if length(c)=0 then exit; {test for cancel or no entry}
StrPCopy(filename,c);
res:=IRReceiveFile(cmd,filename);
end;

procedure TSlinkMain.Exit2Click(Sender: TObject);
begin
halt;
end;

procedure TSlinkMain.OrganizerDriveChange(Sender: TObject);
begin
ConnectClick(Sender);
end;

procedure TSlinkMain.OrganizerFileManager1Click(Sender: TObject);
begin
Apps.PageIndex:=0;
end;

procedure TSlinkMain.Diags1Click(Sender: TObject);
begin
Apps.PageIndex:=1;
end;

procedure TSlinkMain.BuClick(Sender: TObject);
var
c: string;
b: array [0..250] of char;
pass: integer;
begin
 c:= InputBox('Archive File Name', 'FileName ', 'ARCHIVE.ZRA');
 if c<>'' then
 begin
  StrPCopy(b,c);
  pass:=IRBackup(b);
 end;
end;

procedure TSlinkMain.reClick(Sender: TObject);
var
c: string;
b: array [0..250] of char;
pass: integer;
begin
 c:= InputBox('Archive File Name To Restore', 'FileName ', 'ARCHIVE.ZRA');
 StrPCopy(b,c);
 pass:=IRRestore(b);
end;

procedure TSlinkMain.Button1Click(Sender: TObject);
begin
IRShowConfig;
end;

end.
